/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.util.ModRandom;
import java.util.Random;

public class ComboPunchAction
implements IGauntletAction {
    private final ModRandom.RandomCollection<IGauntletAction> punchActions;
    private final EntityLeveledMob entity;
    private final Random rand = new Random();
    private IGauntletAction currentAction;
    int numPunches;

    public ComboPunchAction(ModRandom.RandomCollection<IGauntletAction> punchActions, EntityLeveledMob entity) {
        this.punchActions = punchActions;
        this.entity = entity;
    }

    @Override
    public void doAction() {
        this.numPunches = 2 + this.rand.nextInt(4);
        for (int i = 0; i < this.numPunches; ++i) {
            this.entity.addEvent(() -> {
                this.currentAction = this.punchActions.next();
                this.currentAction.doAction();
            }, i * 60);
        }
    }

    @Override
    public void update() {
        if (this.currentAction != null) {
            this.currentAction.update();
        }
    }

    @Override
    public int attackLength() {
        return (this.numPunches - 1) * 60 + 53;
    }

    @Override
    public boolean shouldExplodeUponImpact() {
        return this.currentAction != null && this.currentAction.shouldExplodeUponImpact();
    }

    @Override
    public boolean isImmuneToDamage() {
        return this.currentAction != null && this.currentAction.isImmuneToDamage();
    }
}

