/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import java.util.OptionalDouble;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityCrimsonCrystal
extends Entity {
    protected static final DataParameter<Float> CLOSEST_TARGET_DISTANCE = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187193_c);
    private EntityLeveledMob shootingEntity = null;
    public static final float explosionDistance = (float)Main.mobsConfig.getDouble("alternative_maelstrom_gauntlet_stage_2.crystal_explosion_radius");
    public static float visualActivationDistance = explosionDistance * 4.0f;
    public static final double VisualActivationDistanceSq = Math.pow(visualActivationDistance, 2.0);
    private static final double explosionRadiusSq = Math.pow(explosionDistance, 2.0);
    private static final float crystalLifespan = (float)Main.mobsConfig.getDouble("alternative_maelstrom_gauntlet_stage_2.crystal_lifespan");

    public EntityCrimsonCrystal(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityCrimsonCrystal(World world, EntityLeveledMob shootingEntity) {
        super(world);
        this.shootingEntity = shootingEntity;
        this.func_70105_a(1.0f, 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            boolean randomExplodeCondition;
            if (this.shootingEntity == null) {
                this.func_70106_y();
                return;
            }
            Vec3d pos = this.func_174791_d();
            OptionalDouble optionalDistance = ModUtils.getEntitiesInBox(this, ModUtils.makeBox(pos, pos).func_186662_g(20.0)).stream().filter(EntityMaelstromMob.CAN_TARGET).mapToDouble(e -> e.func_70068_e((Entity)this)).min();
            if (optionalDistance.isPresent()) {
                this.field_70180_af.func_187227_b(CLOSEST_TARGET_DISTANCE, (Object)Float.valueOf((float)optionalDistance.getAsDouble()));
                if (optionalDistance.getAsDouble() < explosionRadiusSq) {
                    this.explodeAndDespawn();
                }
            } else {
                this.field_70180_af.func_187227_b(CLOSEST_TARGET_DISTANCE, (Object)Float.valueOf(Float.POSITIVE_INFINITY));
            }
            boolean bl = randomExplodeCondition = (float)this.field_70173_aa > crystalLifespan && this.field_70146_Z.nextInt(50) == 0;
            if (randomExplodeCondition && !this.field_70128_L) {
                this.explodeAndDespawn();
            }
        } else if ((double)this.getTargetDistanceSq() < VisualActivationDistanceSq) {
            double distance = Math.sqrt(this.getTargetDistanceSq());
            double distanceToExplosion = ((double)visualActivationDistance - distance) / (double)(visualActivationDistance - explosionDistance);
            int numParticles = (int)(distanceToExplosion * VisualActivationDistanceSq * 0.02);
            for (int i = 0; i < numParticles; ++i) {
                Vec3d vec = ModRandom.randVec().func_72432_b().func_186678_a((double)explosionDistance);
                ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d().func_178787_e(vec), this.getParticleColor());
            }
        }
    }

    public void explodeAndDespawn() {
        this.func_70106_y();
        DamageSource source = ModDamageSource.builder().type("mm:explosionMaelstrom.player").directEntity(this).indirectEntity((Entity)this.shootingEntity).element(this.shootingEntity.getElement()).stoppedByArmorNotShields().build();
        ModUtils.handleAreaImpact(explosionDistance, e -> Float.valueOf(this.shootingEntity.getAttack()), (Entity)this.shootingEntity, this.func_174791_d(), source, 1.0f, 0, false);
        this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false, ModUtils.mobGriefing(this.field_70170_p, (Entity)this.shootingEntity));
        this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f + ModRandom.getFloat(0.2f));
        this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
    }

    public void func_70103_a(byte id) {
        if (id == ModUtils.PARTICLE_BYTE) {
            Vec3d randPos;
            int i;
            for (i = 0; i < 20; ++i) {
                randPos = this.radialRandVec();
                ParticleManager.spawnColoredExplosion(this.field_70170_p, randPos, ModColors.RED);
            }
            for (i = 0; i < 20; ++i) {
                randPos = this.radialRandVec();
                Vec3d outVelocity = ModUtils.direction(this.func_174791_d(), randPos).func_186678_a((double)0.2f);
                ParticleManager.spawnFluff(this.field_70170_p, randPos, Vec3d.field_186680_a, outVelocity);
            }
        }
        super.func_70103_a(id);
    }

    public Vec3d radialRandVec() {
        return this.func_174791_d().func_178787_e(ModRandom.randVec().func_72432_b().func_186678_a(this.field_70146_Z.nextDouble() * (double)explosionDistance));
    }

    private float getTargetDistanceSq() {
        return ((Float)this.field_70180_af.func_187225_a(CLOSEST_TARGET_DISTANCE)).floatValue();
    }

    public Vec3d getParticleColor() {
        double distance = Math.sqrt(Math.min(VisualActivationDistanceSq, (double)this.getTargetDistanceSq()));
        float distanceToExplosion = (float)(((double)visualActivationDistance - distance) / (double)(visualActivationDistance - explosionDistance));
        return new Vec3d(1.0, (double)(1.0f - distanceToExplosion), (double)(1.0f - distanceToExplosion));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CLOSEST_TARGET_DISTANCE, (Object)Float.valueOf(Float.POSITIVE_INFINITY));
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public final boolean func_70075_an() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (EntityMaelstromMob.CAN_TARGET.apply((Object)source.func_76346_g()) && !this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.explodeAndDespawn();
        }
        return super.func_70097_a(source, amount);
    }
}

