/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.EntityAbstractMaelstromGauntlet;
import com.barribob.MaelstromMod.entity.entities.gauntlet.FireballThrowAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.LaserAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.PunchAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.SummonMobsAction;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.projectile.ProjectileMegaFireball;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityMaelstromGauntlet
extends EntityAbstractMaelstromGauntlet {
    Supplier<Vec3d> position = () -> this.func_70638_az() == null ? null : this.func_70638_az().func_174791_d();
    private final IGauntletAction punchAttack = new PunchAction("gauntlet.punch", this.position, () -> {}, this, (Entity)this.fist);
    private final IGauntletAction laserAttack = new LaserAction(this, 39, vec3d -> {});
    private final IGauntletAction summonAttack = new SummonMobsAction(this::spawnMob, this, (Entity)this.fist);
    private final IGauntletAction fireballAttack = new FireballThrowAction<EntityMaelstromGauntlet>(target -> target.func_174824_e(1.0f), this::generateFireball, this);
    private final double fireballHealth = this.getMobConfig().getDouble("use_fireball_at_health");
    private final double lazerHealth = this.getMobConfig().getDouble("use_lazer_at_health");
    private final double spawnHealth = this.getMobConfig().getDouble("use_spawning_at_health");

    public EntityMaelstromGauntlet(World worldIn) {
        super(worldIn);
    }

    private void spawnMob() {
        ModUtils.spawnMob(this.field_70170_p, this.func_180425_c(), this.getLevel(), this.getMobConfig().getConfig("summoning_algorithm"));
    }

    private Projectile generateFireball() {
        ProjectileMegaFireball fireball = new ProjectileMegaFireball(this.field_70170_p, (EntityLivingBase)this, this.getAttack() * this.getConfigFloat("fireball_damage"), null, true);
        fireball.setTravelRange(30.0f);
        return fireball;
    }

    @Override
    protected IGauntletAction getNextAttack(EntityLivingBase target, float distanceSq, IGauntletAction previousAction) {
        ArrayList<IGauntletAction> attacks = new ArrayList<IGauntletAction>(Arrays.asList(this.punchAttack, this.laserAttack, this.summonAttack, this.fireballAttack));
        int numMinions = (int)ModUtils.getEntitiesInBox((Entity)this, this.func_174813_aQ().func_72314_b(20.0, 10.0, 20.0)).stream().filter(EntityMaelstromMob::isMaelstromMob).count();
        double defendWeight = previousAction == this.summonAttack || numMinions > 3 || (double)this.func_110143_aJ() > this.spawnHealth ? 0.0 : 0.8;
        double fireballWeight = (double)distanceSq < Math.pow(25.0, 2.0) && (double)this.func_110143_aJ() < this.fireballHealth ? 1.0 : 0.0;
        double lazerWeight = (double)distanceSq < Math.pow(35.0, 2.0) && (double)this.func_110143_aJ() < this.lazerHealth ? 1.0 : 0.0;
        double punchWeight = ModUtils.canEntityBeSeen((Entity)this, (Entity)target) ? Math.sqrt(distanceSq) / 25.0 : 3.0;
        double[] weights = new double[]{punchWeight, lazerWeight, defendWeight, fireballWeight};
        return ModRandom.choice(attacks, this.field_70146_Z, weights).next();
    }
}

