/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityLargeGoldenRune
extends Projectile {
    private static final byte PARTICLE_BYTE = 3;
    private int tickDelay = 30;
    protected int blastRadius = 4;

    public EntityLargeGoldenRune(World worldIn, EntityLivingBase throwerIn, float damage) {
        super(worldIn, throwerIn, damage);
        this.func_189654_d(true);
    }

    public EntityLargeGoldenRune(World worldIn) {
        super(worldIn);
        this.func_189654_d(true);
    }

    public EntityLargeGoldenRune(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.func_189654_d(true);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= this.tickDelay) {
            this.onHit(null);
        }
    }

    public void setDelay(int delay) {
        this.tickDelay = delay;
    }

    @Override
    protected void onHit(RayTraceResult result) {
        if (result != null) {
            return;
        }
        DamageSource source = ModDamageSource.builder().type("mm:magicMaelstrom").indirectEntity((Entity)this.shootingEntity).directEntity(this).element(this.getElement()).stoppedByArmorNotShields().build();
        ModUtils.handleAreaImpact(this.blastRadius, e -> {
            if (e instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
                this.blastEffect((EntityLivingBase)e);
            }
            return Float.valueOf(this.getDamage());
        }, (Entity)this.shootingEntity, this.func_174791_d(), source, 1.0f, 0, false);
        this.func_184185_a(SoundEvents.field_193784_dd, 1.0f, 0.4f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
        super.onHit(result);
    }

    protected void blastEffect(EntityLivingBase e) {
        e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 0));
    }

    @Override
    protected void spawnImpactParticles() {
        ModUtils.performNTimes(10, i -> {
            ModUtils.circleCallback(this.blastRadius, 30, offset -> ParticleManager.spawnWisp(this.field_70170_p, ModUtils.entityPos(this).func_178787_e(new Vec3d(offset.field_72450_a, (double)i.intValue() * 0.5, offset.field_72448_b)), ModColors.YELLOW, Vec3d.field_186680_a));
            ModUtils.circleCallback(this.blastRadius - 1, 30, offset -> ParticleManager.spawnWisp(this.field_70170_p, ModUtils.entityPos(this).func_178787_e(new Vec3d(offset.field_72450_a, (double)i.intValue() * 0.5, offset.field_72448_b)), ModColors.YELLOW, Vec3d.field_186680_a));
        });
    }

    @Override
    protected void spawnParticles() {
        if (this.field_70173_aa % 10 == 0) {
            ModUtils.circleCallback(this.blastRadius, 45, offset -> ParticleManager.spawnSwirl(this.field_70170_p, ModUtils.entityPos(this).func_178787_e(new Vec3d(offset.field_72450_a, 0.5, offset.field_72448_b)), ModColors.YELLOW, Vec3d.field_186680_a, ModRandom.range(10, 15)));
            ModUtils.circleCallback(this.blastRadius - 1, 30, offset -> ParticleManager.spawnSwirl(this.field_70170_p, ModUtils.entityPos(this).func_178787_e(new Vec3d(offset.field_72450_a, (double)0.6f, offset.field_72448_b)), ModColors.YELLOW, Vec3d.field_186680_a, ModRandom.range(10, 15)));
            ModUtils.circleCallback(this.blastRadius - 2, 30, offset -> ParticleManager.spawnSwirl(this.field_70170_p, ModUtils.entityPos(this).func_178787_e(new Vec3d(offset.field_72450_a, (double)0.7f, offset.field_72448_b)), ModColors.YELLOW, Vec3d.field_186680_a, ModRandom.range(10, 15)));
        }
    }
}

