/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileBeastFireball
extends Projectile {
    private static final int PARTICLE_AMOUNT = 15;
    private static final int IMPACT_PARTICLE_AMOUNT = 150;
    private static final int EXPOSION_AREA_FACTOR = 3;

    public ProjectileBeastFireball(World worldIn, EntityLivingBase throwerIn, float baseDamage) {
        super(worldIn, throwerIn, baseDamage);
        this.func_189654_d(true);
    }

    public ProjectileBeastFireball(World worldIn) {
        super(worldIn);
        this.func_189654_d(true);
    }

    public ProjectileBeastFireball(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.func_189654_d(true);
    }

    @Override
    protected void spawnParticles() {
        float size = 0.5f;
        for (int i = 0; i < 15; ++i) {
            ParticleManager.spawnDarkFlames(this.field_70170_p, this.field_70146_Z, ModUtils.entityPos(this).func_178787_e(ModRandom.randVec().func_186678_a((double)size)));
        }
    }

    @Override
    protected void spawnImpactParticles() {
        Vec3d pos;
        int i;
        float size = (float)(3.0 * this.func_174813_aQ().func_186662_g(3.0).func_72320_b() * 0.5);
        for (i = 0; i < 150; ++i) {
            pos = ModUtils.entityPos(this).func_178787_e(ModRandom.randVec().func_186678_a((double)size));
            if (this.field_70146_Z.nextInt(2) == 0) {
                ParticleManager.spawnDarkFlames(this.field_70170_p, this.field_70146_Z, pos, ModRandom.randVec().func_186678_a(0.5));
                continue;
            }
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)ModRandom.getFloat(0.25f), (double)ModRandom.getFloat(0.25f), (double)ModRandom.getFloat(0.25f), new int[0]);
        }
        for (i = 0; i < 10; ++i) {
            pos = ModUtils.entityPos(this).func_178787_e(ModRandom.randVec().func_186678_a((double)size));
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)ModRandom.getFloat(0.25f), (double)ModRandom.getFloat(0.25f), (double)ModRandom.getFloat(0.25f), new int[0]);
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && this.shootingEntity != null) {
            DamageSource source = ModDamageSource.builder().type("mm:explosionMaelstrom.player").directEntity(this).indirectEntity((Entity)this.shootingEntity).element(this.getElement()).stoppedByArmorNotShields().build();
            ModUtils.handleAreaImpact(3.0f, e -> {
                if (e instanceof EntityLivingBase) {
                    ((EntityLivingBase)e).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 80, 0));
                }
                return Float.valueOf(this.getDamage());
            }, (Entity)this.shootingEntity, this.func_174791_d(), source, 1.0f, 0);
            this.field_70170_p.func_72876_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, ModUtils.mobGriefing(this.field_70170_p, (Entity)this.shootingEntity));
        }
        super.onHit(result);
    }
}

