/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.EntityCrimsonCrystal;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileCrimsonWanderer
extends Projectile {
    private static final int AGE = 80;

    public ProjectileCrimsonWanderer(World worldIn, EntityLivingBase throwerIn, float baseDamage) {
        super(worldIn, throwerIn, baseDamage);
    }

    public ProjectileCrimsonWanderer(World worldIn) {
        super(worldIn);
    }

    public ProjectileCrimsonWanderer(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    public void func_70071_h_() {
        Vec3d prevVel = ModUtils.getEntityVelocity(this);
        super.func_70071_h_();
        ModUtils.setEntityVelocity(this, prevVel);
        if (!this.field_70170_p.field_72995_K) {
            ModUtils.avoidOtherEntities(this, 0.03, 3, e -> e instanceof ProjectileCrimsonWanderer || e == this.shootingEntity);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 80) {
            this.onImpact();
            this.func_70106_y();
        }
    }

    private void onImpact() {
        if (this.shootingEntity != null && this.shootingEntity instanceof EntityLeveledMob) {
            EntityCrimsonCrystal crystal = new EntityCrimsonCrystal(this.field_70170_p, (EntityLeveledMob)this.shootingEntity);
            ModUtils.setEntityPosition(crystal, this.func_174791_d());
            this.field_70170_p.func_72838_d((Entity)crystal);
        }
    }

    @Override
    protected void onHit(@Nullable RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.onImpact();
        }
        super.onHit(result);
    }

    @Override
    protected void spawnParticles() {
        for (int i = 0; i < 4; ++i) {
            float colorAge = ModUtils.clamp(Math.pow((float)this.field_70173_aa / 80.0f, 2.0), 0.1, 1.0);
            ParticleManager.spawnSplit(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(0.25)), new Vec3d(1.0, (double)colorAge, (double)colorAge), Vec3d.field_186680_a);
        }
    }
}

