/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IElement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProjectileGun
extends Projectile {
    private int knockbackStrength;
    private int maelstromDestroyer;
    private int criticalHit;
    private boolean isCritical;
    private static final byte CRITICAL_BYTE = 5;

    public ProjectileGun(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack, Element element) {
        this(worldIn, throwerIn, baseDamage, stack);
        this.setElement(element);
    }

    public ProjectileGun(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack) {
        super(worldIn, throwerIn, baseDamage);
        if (stack != null) {
            if (this.field_70146_Z.nextInt(8) == 0 && this.criticalHit > 0 && !this.field_70170_p.field_72995_K) {
                this.isCritical = true;
                this.setDamage(this.getDamage() * (float)this.criticalHit * 2.5f);
            }
            this.func_70015_d(100);
            if (stack.func_77973_b() instanceof IElement) {
                this.setElement(((IElement)stack.func_77973_b()).getElement());
            }
        }
    }

    protected int getKnockback() {
        return this.knockbackStrength;
    }

    protected float getGunDamage(Entity entity) {
        if (!EntityMaelstromMob.CAN_TARGET.apply((Object)entity)) {
            float maxDamageBonus = (float)(Math.pow(ModConfig.balance.progression_scale, 2.5) - 1.0);
            float damageBonus = super.getDamage() * maxDamageBonus * ((float)this.maelstromDestroyer / 10.0f);
            return super.getDamage() + damageBonus;
        }
        return super.getDamage();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isCritical) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 5) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        } else {
            super.func_70103_a(id);
        }
    }

    public ProjectileGun(World worldIn) {
        super(worldIn);
    }

    public ProjectileGun(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }
}

