/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileHorrorAttack
extends Projectile {
    private static final int PARTICLE_AMOUNT = 1;
    private static final int IMPACT_PARTICLE_AMOUNT = 20;
    private static final int EXPOSION_AREA_FACTOR = 6;

    public ProjectileHorrorAttack(World worldIn, EntityLivingBase throwerIn, float damage) {
        super(worldIn, throwerIn, damage);
    }

    public ProjectileHorrorAttack(World worldIn) {
        super(worldIn);
    }

    public ProjectileHorrorAttack(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void spawnParticles() {
        for (int i = 0; i < 1; ++i) {
            ParticleManager.spawnColoredSmoke(this.field_70170_p, this.func_174791_d(), this.getElement().particleColor, new Vec3d(0.0, 0.1, 0.0));
        }
    }

    @Override
    protected void spawnImpactParticles() {
        for (int i = 0; i < 20; ++i) {
            Vec3d vec1 = ModRandom.randVec().func_186678_a(1.5).func_178787_e(this.func_174791_d());
            ParticleManager.spawnColoredExplosion(this.field_70170_p, vec1, this.getElement().particleColor);
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
        DamageSource source = ModDamageSource.builder().indirectEntity((Entity)this.shootingEntity).directEntity(this).type("mm:explosionMaelstrom.player").element(this.getElement()).stoppedByArmorNotShields().build();
        ModUtils.handleAreaImpact(6.0f, e -> Float.valueOf(this.getDamage()), (Entity)this.shootingEntity, this.func_174791_d(), source);
        this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        super.onHit(result);
    }
}

