/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.packets;

import com.barribob.MaelstromMod.packets.PacketUtils;
import com.barribob.MaelstromMod.particle.EnumModParticles;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageModParticles
implements IMessage {
    private EnumModParticles particleType;
    float xCoord;
    float yCoord;
    float zCoord;
    float xOffset;
    float yOffset;
    float zOffset;
    float[] particleArguments;

    public MessageModParticles() {
    }

    public MessageModParticles(EnumModParticles particleIn, Vec3d pos, Vec3d vel, Vec3d color) {
        this(particleIn, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c, (float)vel.field_72450_a, (float)vel.field_72448_b, (float)vel.field_72449_c, (float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c);
    }

    public MessageModParticles(EnumModParticles particleIn, float xIn, float yIn, float zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float ... argumentsIn) {
        this.particleType = particleIn;
        this.xCoord = xIn;
        this.yCoord = yIn;
        this.zCoord = zIn;
        this.xOffset = xOffsetIn;
        this.yOffset = yOffsetIn;
        this.zOffset = zOffsetIn;
        this.particleArguments = argumentsIn;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumModParticles getParticleType() {
        return this.particleType;
    }

    @SideOnly(value=Side.CLIENT)
    public double getXCoordinate() {
        return this.xCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public double getYCoordinate() {
        return this.yCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZCoordinate() {
        return this.zCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public float getXOffset() {
        return this.xOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getYOffset() {
        return this.yOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getZOffset() {
        return this.zOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getParticleArgs() {
        return this.particleArguments;
    }

    public void fromBytes(ByteBuf buf) {
        this.particleType = EnumModParticles.getParticleFromId(buf.readInt());
        if (this.particleType == null) {
            this.particleType = EnumModParticles.SWEEP_ATTACK;
        }
        this.xCoord = buf.readFloat();
        this.yCoord = buf.readFloat();
        this.zCoord = buf.readFloat();
        this.xOffset = buf.readFloat();
        this.yOffset = buf.readFloat();
        this.zOffset = buf.readFloat();
        int i = this.particleType.getArgumentCount();
        this.particleArguments = new float[i];
        for (int j = 0; j < i; ++j) {
            this.particleArguments[j] = buf.readFloat();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particleType.getParticleID());
        buf.writeFloat(this.xCoord);
        buf.writeFloat(this.yCoord);
        buf.writeFloat(this.zCoord);
        buf.writeFloat(this.xOffset);
        buf.writeFloat(this.yOffset);
        buf.writeFloat(this.zOffset);
        int i = this.particleType.getArgumentCount();
        for (int j = 0; j < i; ++j) {
            buf.writeFloat(this.particleArguments[j]);
        }
    }

    public static class MessageHandler
    implements IMessageHandler<MessageModParticles, IMessage> {
        public IMessage onMessage(MessageModParticles message, MessageContext ctx) {
            if (message.particleType.equals((Object)EnumModParticles.SWEEP_ATTACK)) {
                PacketUtils.spawnSweepParticles(message);
            } else if (message.particleType.equals((Object)EnumModParticles.EFFECT)) {
                PacketUtils.spawnEffect(message);
            }
            return null;
        }
    }
}

