/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.ITankManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDropperUse
implements IMessageHandler<DropperUseMessage, IMessage> {
    public IMessage onMessage(DropperUseMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity instanceof ITankManager) {
                try {
                    Object tank = ((ITankManager)tileEntity).getTanks()[message.tankId];
                    if (tank != null) {
                        ITankManager.DropperHandler.useDropper(player, tank, message.mouseButton);
                    }
                }
                catch (Exception e) {
                    Mekanism.logger.error("FIXME: Packet handling error", (Throwable)e);
                }
            }
        }, player);
        return null;
    }

    public static class DropperUseMessage
    implements IMessage {
        public Coord4D coord4D;
        public int mouseButton;
        public int tankId;

        public DropperUseMessage() {
        }

        public DropperUseMessage(Coord4D coord, int button, int id) {
            this.coord4D = coord;
            this.mouseButton = button;
            this.tankId = id;
        }

        public void toBytes(ByteBuf dataStream) {
            this.coord4D.write(dataStream);
            dataStream.writeInt(this.mouseButton);
            dataStream.writeInt(this.tankId);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = Coord4D.read(dataStream);
            this.mouseButton = dataStream.readInt();
            this.tankId = dataStream.readInt();
        }
    }
}

