/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class MinerUtils {
    public static final List<Block> specialSilkIDs = Arrays.asList(Blocks.field_150432_aD, Blocks.field_185766_cS);
    private static Method getSilkTouchDrop = null;

    public static List<ItemStack> getDrops(World world, Coord4D coord, boolean silk, BlockPos minerPosition) {
        IBlockState state = coord.getBlockState((IBlockAccess)world);
        Block block = state.func_177230_c();
        EntityPlayer fakePlayer = (EntityPlayer)Mekanism.proxy.getDummyPlayer((WorldServer)world, minerPosition).get();
        if (block.isAir(state, (IBlockAccess)world, coord.getPos())) {
            return Collections.emptyList();
        }
        if (block instanceof BlockShulkerBox) {
            TileEntityShulkerBox tileentityshulkerbox;
            ItemStack shulkerBoxItem = new ItemStack(Item.func_150898_a((Block)block));
            TileEntity tileentity = world.func_175625_s(coord.getPos());
            if (tileentity instanceof TileEntityShulkerBox && !(tileentityshulkerbox = (TileEntityShulkerBox)tileentity).func_190590_r() && tileentityshulkerbox.func_190582_F()) {
                NBTTagCompound itemTag = new NBTTagCompound();
                NBTTagCompound nbtBlockEntity = new NBTTagCompound();
                itemTag.func_74782_a("BlockEntityTag", (NBTBase)((TileEntityShulkerBox)tileentity).func_190580_f(nbtBlockEntity));
                shulkerBoxItem.func_77982_d(itemTag);
                if (tileentityshulkerbox.func_145818_k_()) {
                    shulkerBoxItem.func_151001_c(tileentityshulkerbox.func_70005_c_());
                }
            }
            return Collections.singletonList(shulkerBoxItem);
        }
        if (silk && (block.canSilkHarvest(world, coord.getPos(), state, fakePlayer) || specialSilkIDs.contains(block))) {
            Object it = null;
            if (getSilkTouchDrop != null) {
                try {
                    it = getSilkTouchDrop.invoke((Object)block, state);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Mekanism.logger.error("Block.getSilkTouchDrop errored", (Throwable)e);
                }
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            if (it instanceof ItemStack && !((ItemStack)it).func_190926_b()) {
                ret.add((ItemStack)it);
            } else {
                Item item = Item.func_150898_a((Block)block);
                if (item != Items.field_190931_a) {
                    ret.add(new ItemStack(item, 1, item.func_77614_k() ? block.func_176201_c(state) : 0));
                }
            }
            if (ret.size() > 0) {
                ForgeEventFactory.fireBlockHarvesting(ret, (World)world, (BlockPos)coord.getPos(), (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                return ret;
            }
        } else {
            List blockDrops = block.getDrops((IBlockAccess)world, coord.getPos(), state, 0);
            if (blockDrops.size() > 0) {
                ForgeEventFactory.fireBlockHarvesting((List)blockDrops, (World)world, (BlockPos)coord.getPos(), (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
            } else if (block == Blocks.field_185766_cS) {
                blockDrops.add(new ItemStack(Blocks.field_185766_cS));
            }
            return blockDrops;
        }
        return Collections.emptyList();
    }

    static {
        try {
            getSilkTouchDrop = ReflectionHelper.findMethod(Block.class, (String)"getSilkTouchDrop", (String)"func_180643_i", (Class[])new Class[]{IBlockState.class});
        }
        catch (ReflectionHelper.UnableToFindMethodException e) {
            Mekanism.logger.error("Unable to find method Block.getSilkTouchDrop");
        }
    }
}

