/*
 * Decompiled with CFR 0.152.
 */
package mekanism.coremod;

import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class KeybindingMigrationHelper
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism KeybindingMigrationHelper");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.client.settings.GameSettings")) {
            return basicClass;
        }
        ClassWriter cw = new ClassWriter(0);
        new ClassReader(basicClass).accept((ClassVisitor)new Visitor((ClassVisitor)cw), 8);
        return cw.toByteArray();
    }

    private static class Visitor
    extends ClassVisitor {
        private static final String DATAFIX_SIG = "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;";
        private final String datafixMethodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName("net/minecraft/client/settings/GameSettings", "func_189988_a", "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;");

        Visitor(ClassVisitor parent) {
            super(327680, parent);
            LOGGER.debug("Looking for " + this.datafixMethodName + DATAFIX_SIG);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals(this.datafixMethodName) && desc.equals(DATAFIX_SIG)) {
                LOGGER.info("Patching GameSettings.datafix");
                return new GeneratorAdapter(327680, visitor, access, name, desc){

                    public void visitCode() {
                        super.visitCode();
                        this.loadArg(0);
                        this.invokeStatic(Type.getObjectType((String)"mekanism/common/fixers/KeybindingFixer"), new Method("runFix", "(Lnet/minecraft/nbt/NBTTagCompound;)V"));
                    }
                };
            }
            return visitor;
        }
    }
}

