/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.network.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zabi.minecraft.minerva.common.network.container.TransferRule;
import zabi.minecraft.minerva.common.network.container.slot.SlotFiltered;
import zabi.minecraft.minerva.common.network.container.slot.SlotOutput;

public class ModContainer<T extends TileEntity>
extends Container {
    private int internalSlots = 0;
    private final T tileEntity;
    private List<Slot> destinations = Lists.newArrayList();
    private List<TransferRule> rules = Lists.newArrayList();

    public ModContainer(T tileEntity) {
        this.tileEntity = tileEntity;
    }

    protected void addPlayerSlots(InventoryPlayer playerInventory, int x, int y) {
        int i;
        this.finalizeSlots();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, x + i * 18, y + 58));
        }
    }

    private void finalizeSlots() {
        ArrayList<Slot> generic = new ArrayList<Slot>();
        for (Slot s : this.field_75151_b) {
            if (s instanceof SlotFiltered) {
                this.destinations.add(s);
                continue;
            }
            if (s instanceof SlotOutput) continue;
            generic.add(s);
        }
        this.destinations.addAll(generic);
        this.internalSlots = this.field_75151_b.size();
    }

    protected void addPlayerSlots(InventoryPlayer playerInventory) {
        this.addPlayerSlots(playerInventory, 8, 84);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.field_75151_b.size()) {
            return ItemStack.field_190927_a;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            if (slotIndex < this.internalSlots) {
                return this.transferStackToPlayerInventory(player, slot, slotIndex);
            }
            for (TransferRule tr : this.rules) {
                if (!tr.test(slot)) continue;
                return this.mergeAndUpdate(player, slot, slotIndex, tr.getStart(), tr.getEnd(), false);
            }
            return this.transferStackToContainer(player, slot, slotIndex);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    protected ItemStack transferStackToContainer(EntityPlayer player, Slot slot, int slotIndex) {
        List<Slot> validDestinations = this.destinations.stream().filter(s -> s.getSlotIndex() < this.internalSlots).filter(s -> this.checkFilteredSlot((Slot)s, slot)).collect(Collectors.toList());
        if (validDestinations.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Tuple<Integer, Integer> range = this.getRange(validDestinations);
        return this.mergeAndUpdate(player, slot, slotIndex, (Integer)range.func_76341_a(), (Integer)range.func_76340_b(), false);
    }

    private Tuple<Integer, Integer> getRange(List<Slot> validDestinations) {
        int start = validDestinations.get((int)0).field_75222_d;
        int end = start + 1;
        for (int i = 1; i < validDestinations.size() && validDestinations.get((int)i).field_75222_d == end; ++end, ++i) {
        }
        return new Tuple((Object)start, (Object)end);
    }

    private boolean checkFilteredSlot(Slot s, Slot clicked) {
        if (s instanceof SlotFiltered) {
            return s.func_75214_a(clicked.func_75211_c());
        }
        return true;
    }

    @Nonnull
    protected ItemStack transferStackToPlayerInventory(EntityPlayer player, Slot slot, int slotIndex) {
        return this.mergeAndUpdate(player, slot, slotIndex, this.internalSlots, this.field_75151_b.size(), false);
    }

    protected ItemStack mergeAndUpdate(EntityPlayer player, Slot slot, int slotIndex, int startIndex, int stopIndex, boolean reversed) {
        ItemStack origStack = slot.func_75211_c();
        ItemStack copyStack = origStack.func_77946_l();
        if (!this.func_75135_a(origStack, startIndex, stopIndex, reversed)) {
            return ItemStack.field_190927_a;
        }
        slot.func_75220_a(origStack, copyStack);
        if (origStack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        if (origStack.func_190916_E() == copyStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_190901_a(player, origStack);
        return origStack;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return !player.func_175149_v();
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    protected int getFieldsToSync() {
        return 0;
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.field_75149_d.forEach(l -> this.sendChangesToListener((IContainerListener)l));
    }

    private void sendChangesToListener(IContainerListener l) {
        for (int i = 0; i < this.getFieldsToSync(); ++i) {
            l.func_71112_a((Container)this, i, this.getFieldFromTile(i));
        }
    }

    public int getFieldFromTile(int id) {
        return 0;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.sendChangesToListener(listener);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        this.onFieldUpdated(id, data);
    }

    @SideOnly(value=Side.CLIENT)
    protected void onFieldUpdated(int id, int data) {
    }

    public ModContainer<T> addRule(TransferRule rule) {
        this.rules.add(rule);
        return this;
    }
}

