/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.tileentity;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import zabi.minecraft.minerva.common.mod.MLog;

public class JointInventoryWrapper
implements IItemHandlerModifiable {
    private ArrayList<Tuple<Supplier<ItemStackHandler>, Integer>> bindings = new ArrayList();
    private ArrayList<Mode> modes = new ArrayList();

    public int getSlots() {
        return this.bindings.size();
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.bindings.size() || this.bindings.get(slot) == null) {
            return ItemStack.field_190927_a;
        }
        Tuple<Supplier<ItemStackHandler>, Integer> res = this.bindings.get(slot);
        return ((ItemStackHandler)((Supplier)res.func_76341_a()).get()).getStackInSlot(((Integer)res.func_76340_b()).intValue());
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot >= this.bindings.size() || this.bindings.get(slot) == null || !this.modes.get(slot).canInsert()) {
            return stack;
        }
        Tuple<Supplier<ItemStackHandler>, Integer> res = this.bindings.get(slot);
        return ((ItemStackHandler)((Supplier)res.func_76341_a()).get()).insertItem(((Integer)res.func_76340_b()).intValue(), stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.bindings.size() || this.bindings.get(slot) == null || !this.modes.get(slot).canExtract()) {
            return ItemStack.field_190927_a;
        }
        Tuple<Supplier<ItemStackHandler>, Integer> res = this.bindings.get(slot);
        return ((ItemStackHandler)((Supplier)res.func_76341_a()).get()).extractItem(((Integer)res.func_76340_b()).intValue(), amount, simulate);
    }

    public int getSlotLimit(int slot) {
        if (slot >= this.bindings.size() || this.bindings.get(slot) == null) {
            return 0;
        }
        Tuple<Supplier<ItemStackHandler>, Integer> res = this.bindings.get(slot);
        return ((ItemStackHandler)((Supplier)res.func_76341_a()).get()).getSlotLimit(((Integer)res.func_76340_b()).intValue());
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot >= this.bindings.size() || this.bindings.get(slot) == null) {
            MLog.w("Slot " + slot + " wasn't bound properly: " + stack);
        }
        Tuple<Supplier<ItemStackHandler>, Integer> res = this.bindings.get(slot);
        ((ItemStackHandler)((Supplier)res.func_76341_a()).get()).setStackInSlot(((Integer)res.func_76340_b()).intValue(), stack);
    }

    public JointInventoryWrapper bind(Supplier<ItemStackHandler> handler, int slot, Mode mode) {
        this.bindings.add((Tuple<Supplier<ItemStackHandler>, Integer>)new Tuple(handler, (Object)slot));
        this.modes.add(mode);
        return this;
    }

    public static enum Mode {
        INSERT(true, false),
        EXTRACT(false, true),
        BOTH(true, true),
        NONE(false, false);

        private boolean r_in;
        private boolean r_out;

        private Mode(boolean in, boolean out) {
            this.r_in = in;
            this.r_out = out;
        }

        public boolean canInsert() {
            return this.r_in;
        }

        public boolean canExtract() {
            return this.r_out;
        }
    }
}

