/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thaumcraft.handlers.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.compat.thaumcraft.handlers.ThaumCraft;
import com.blamejared.compat.thaumcraft.handlers.aspects.CTAspectStack;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;

@ZenClass(value="mods.thaumcraft.ArcaneWorkbench")
@ZenRegister
@ModOnly(value="thaumcraft")
public class ArcaneWorkbench {
    @ZenMethod
    public static void registerShapedRecipe(String name, String research, int vis, CTAspectStack[] aspectList, IItemStack output, IIngredient[][] input) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddShaped(new ResourceLocation("thaumcraft", name), research, vis, ThaumCraft.getAspects(aspectList), InputHelper.toStack((IItemStack)output), InputHelper.toShapedObjects((IIngredient[][])input)));
    }

    @ZenMethod
    public static void registerShapelessRecipe(String name, String research, int vis, CTAspectStack[] aspectList, IItemStack output, IIngredient[] input) {
        NonNullList list = NonNullList.func_191197_a((int)input.length, (Object)Ingredient.field_193370_a);
        for (int i = 0; i < input.length; ++i) {
            list.set(i, (Object)CraftTweakerMC.getIngredient((IIngredient)input[i]));
        }
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddShapeless(new ResourceLocation("thaumcraft", name), research, vis, ThaumCraft.getAspects(aspectList), InputHelper.toStack((IItemStack)output), (NonNullList<Ingredient>)list));
    }

    @ZenMethod
    public static void removeRecipe(String name) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(name));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    public static class AddShapeless
    extends BaseAction {
        private ResourceLocation location;
        private String research;
        private int vis;
        private AspectList list;
        private ItemStack output;
        private NonNullList<Ingredient> shapeless;

        public AddShapeless(ResourceLocation location, String research, int vis, AspectList list, ItemStack output, NonNullList<Ingredient> shapeless) {
            super("ArcaneWorkbench");
            this.location = location;
            this.research = research;
            this.vis = vis;
            this.list = list;
            this.output = output;
            this.shapeless = shapeless;
        }

        public void apply() {
            ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)this.location, (IArcaneRecipe)new ShapelessArcaneRecipe(this.location, this.research, this.vis, this.list, this.shapeless, this.output));
        }

        public String describe() {
            return "Adding shapeless recipe for ArcaneWorkbench with name: " + this.location + " with output: " + LogHelper.getStackDescription((Object)this.output);
        }
    }

    public static class AddShaped
    extends BaseAction {
        private ResourceLocation location;
        private String research;
        private int vis;
        private AspectList list;
        private ItemStack output;
        private Object[] shaped;

        public AddShaped(ResourceLocation location, String research, int vis, AspectList list, ItemStack output, Object[] shaped) {
            super("ArcaneWorkbench");
            this.location = location;
            this.research = research;
            this.vis = vis;
            this.list = list;
            this.output = output;
            this.shaped = shaped;
        }

        public void apply() {
            ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)this.location, (IArcaneRecipe)new ShapedArcaneRecipe(this.location, this.research, this.vis, this.list, this.output, this.shaped));
        }

        public String describe() {
            return "Adding shaped recipe for ArcaneWorkbench with name: " + this.location + " with output: " + LogHelper.getStackDescription((Object)this.output);
        }
    }

    public static class Remove
    extends BaseAction {
        private String name;
        private IItemStack output;

        public Remove(String name) {
            super("ArcaneWorkbench");
            this.name = name;
        }

        public Remove(IItemStack output) {
            super("ArcaneWorkbench");
            this.output = output;
        }

        public void apply() {
            ArrayList removed = new ArrayList();
            for (Map.Entry entry : ForgeRegistries.RECIPES.getEntries()) {
                if (!(entry.getValue() instanceof IArcaneRecipe)) continue;
                if (this.name != null && !this.name.isEmpty() && ((ResourceLocation)entry.getKey()).toString().equals(this.name)) {
                    removed.add(entry.getKey());
                }
                if (this.output == null || !this.output.matches(InputHelper.toIItemStack((ItemStack)((IRecipe)entry.getValue()).func_77571_b()))) continue;
                removed.add(entry.getKey());
            }
            removed.forEach(arg_0 -> ((ForgeRegistry)RegistryManager.ACTIVE.getRegistry(GameData.RECIPES)).remove(arg_0));
        }
    }
}

