/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.GuiListBiomesEntry;
import com.chaosthedude.naturescompass.gui.GuiNaturesCompass;
import com.chaosthedude.naturescompass.util.RenderUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiListBiomes
extends GuiListExtended {
    private final GuiNaturesCompass guiNaturesCompass;
    private final List<GuiListBiomesEntry> entries = Lists.newArrayList();
    private int selectedIndex = -1;

    public GuiListBiomes(GuiNaturesCompass guiNaturesCompass, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.guiNaturesCompass = guiNaturesCompass;
        this.refreshList();
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 20;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 50;
    }

    protected boolean func_148131_a(int slotIndex) {
        return slotIndex == this.selectedIndex;
    }

    public void func_178039_p() {
        int i2 = Mouse.getEventDWheel();
        if (i2 != 0) {
            if (i2 > 0) {
                i2 = -1;
            } else if (i2 < 0) {
                i2 = 1;
            }
            this.field_148169_q += (float)(i2 * this.field_148149_f);
        } else {
            super.func_178039_p();
        }
    }

    public void func_148128_a(int parMouseX, int parMouseY, float partialTicks) {
        if (this.field_178041_q) {
            this.field_148150_g = parMouseX;
            this.field_148162_h = parMouseY;
            this.func_148123_a();
            int x = this.func_148137_d();
            int j = x + 6;
            this.func_148121_k();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            this.drawContainerBackground(tessellator);
            int insideLeft = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2 + 2;
            int insideTop = this.field_148153_b + 4 - (int)this.field_148169_q;
            if (this.field_148165_u) {
                this.func_148129_a(insideLeft, insideTop, tessellator);
            }
            this.func_192638_a(insideLeft, insideTop, parMouseX, parMouseY, partialTicks);
        }
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        this.guiNaturesCompass.func_146276_q_();
    }

    protected void func_192638_a(int insideLeft, int insideTop, int mouseX, int mouseY, float partialTicks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (int i = 0; i < this.func_148127_b(); ++i) {
            int k = insideTop + i * this.field_148149_f + this.field_148160_j;
            int l = this.field_148149_f - 4;
            if (k > this.field_148154_c || k + l < this.field_148153_b) {
                this.func_192639_a(i, insideLeft, k, partialTicks);
            }
            if (this.field_148166_t && this.func_148131_a(i)) {
                RenderUtils.drawRect(insideLeft - 4, k - 4, insideLeft + this.func_148139_c() + 4, k + this.field_148149_f, 0x7F000000);
            }
            this.func_192637_a(i, insideLeft, k, l, mouseX, mouseY, partialTicks);
        }
    }

    public GuiListBiomesEntry getListEntry(int index) {
        return this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    @Nullable
    public GuiListBiomesEntry getSelectedBiome() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.func_148127_b() ? this.getListEntry(this.selectedIndex) : null;
    }

    public void refreshList() {
        this.entries.clear();
        for (Biome biome : this.guiNaturesCompass.sortBiomes()) {
            this.entries.add(new GuiListBiomesEntry(this, biome));
        }
        this.selectBiome(-1);
    }

    public void selectBiome(int index) {
        this.selectedIndex = index;
        this.guiNaturesCompass.selectBiome(this.getSelectedBiome());
    }

    public GuiNaturesCompass getGuiNaturesCompass() {
        return this.guiNaturesCompass;
    }
}

