/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSync
implements IMessage {
    private boolean canTeleport;
    private List<Biome> allowedBiomes;

    public PacketSync() {
    }

    public PacketSync(boolean canTeleport, List<Biome> allowedBiomes) {
        this.canTeleport = canTeleport;
        this.allowedBiomes = allowedBiomes;
    }

    public void fromBytes(ByteBuf buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedBiomes = new ArrayList<Biome>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.allowedBiomes.add(Biome.func_185357_a((int)buf.readInt()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedBiomes.size());
        for (Biome biome : this.allowedBiomes) {
            buf.writeInt(Biome.func_185362_a((Biome)biome));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSync, IMessage> {
        public IMessage onMessage(PacketSync packet, MessageContext ctx) {
            NaturesCompass.canTeleport = packet.canTeleport;
            NaturesCompass.allowedBiomes = packet.allowedBiomes;
            return null;
        }
    }
}

