/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.postfix;

import com.google.common.collect.Maps;
import info.openmods.calc.parsing.postfix.IExecutableListBuilder;
import info.openmods.calc.parsing.postfix.IPostfixParserState;
import info.openmods.calc.parsing.postfix.PostfixParser;
import info.openmods.calc.parsing.postfix.SimplePostfixParserState;
import java.util.Map;

public abstract class MappedPostfixParser<E>
extends PostfixParser<E> {
    private final Map<String, IStateProvider<E>> modifierStates = Maps.newHashMap();
    private final Map<String, IStateProvider<E>> bracketStates = Maps.newHashMap();

    @Override
    protected IPostfixParserState<E> createInitialState() {
        return new SimplePostfixParserState<E>(this.createListBuilder());
    }

    protected abstract IExecutableListBuilder<E> createListBuilder();

    @Override
    protected IPostfixParserState<E> createStateForModifier(String modifier) {
        IStateProvider<E> stateProvider = this.modifierStates.get(modifier);
        return stateProvider != null ? stateProvider.createState() : super.createStateForModifier(modifier);
    }

    public MappedPostfixParser<E> addModifierStateProvider(String modifier, IStateProvider<E> stateProvider) {
        this.modifierStates.put(modifier, stateProvider);
        return this;
    }

    @Override
    protected IPostfixParserState<E> createStateForBracket(String bracket) {
        IStateProvider<E> stateProvider = this.bracketStates.get(bracket);
        return stateProvider != null ? stateProvider.createState() : super.createStateForBracket(bracket);
    }

    public MappedPostfixParser<E> addBracketStateProvider(String modifier, IStateProvider<E> stateProvider) {
        this.bracketStates.put(modifier, stateProvider);
        return this;
    }

    public static interface IStateProvider<E> {
        public IPostfixParserState<E> createState();
    }
}

