/*
 * Decompiled with CFR 0.152.
 */
package us.bemrose.mc.pitweaks;

import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import us.bemrose.mc.pitweaks.Tweak;
import us.bemrose.mc.pitweaks.TweakConfig;

public class RepairCostTweak
extends Tweak {
    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (TweakConfig.anvil.noRepairCost) {
            RepairCostTweak.clearRepairCost(left);
            RepairCostTweak.clearRepairCost(right);
        }
        if (!TweakConfig.anvil.alwaysAllowBooks && !TweakConfig.anvil.allowOverlevelBooks) {
            return;
        }
        if (!left.func_190926_b() && !right.func_190926_b() && Items.field_151134_bR == right.func_77973_b()) {
            int cost = 0;
            Map currentEnchants = EnchantmentHelper.func_82781_a((ItemStack)left);
            for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)right).entrySet()) {
                int outLevel;
                Enchantment ench = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                if (null == ench || 0 == level || !RepairCostTweak.canApplyEnchant(left, ench)) continue;
                int currentLevel = 0;
                if (currentEnchants.containsKey(ench)) {
                    currentLevel = (Integer)currentEnchants.get(ench);
                }
                if (currentLevel > level) continue;
                int n = outLevel = currentLevel == level ? level + 1 : level;
                if (!TweakConfig.anvil.allowOverlevelBooks) {
                    outLevel = Math.min(outLevel, ench.func_77325_b());
                }
                if (outLevel <= currentLevel) continue;
                currentEnchants.put(ench, outLevel);
                cost += RepairCostTweak.getApplyCost(ench, outLevel);
            }
            if (cost > 0) {
                ItemStack out = left.func_77946_l();
                EnchantmentHelper.func_82782_a((Map)currentEnchants, (ItemStack)out);
                String name = event.getName();
                if (name != null && !name.isEmpty()) {
                    out.func_151001_c(name);
                    ++cost;
                }
                event.setOutput(out);
                event.setCost(cost);
            } else {
                event.setCanceled(true);
            }
        }
    }

    private static boolean canApplyEnchant(ItemStack i, Enchantment e) {
        if (TweakConfig.anvil.alwaysAllowBooks) {
            return true;
        }
        if (Items.field_151134_bR == i.func_77973_b()) {
            return true;
        }
        if (!e.func_92089_a(i)) {
            return false;
        }
        for (Enchantment enchCompare : EnchantmentHelper.func_82781_a((ItemStack)i).keySet()) {
            if (enchCompare == null || enchCompare == e || enchCompare.func_191560_c(e)) continue;
            return false;
        }
        return true;
    }

    private static int getApplyCost(Enchantment e, int lvl) {
        int rarityFactor = 10;
        Enchantment.Rarity r = e.func_77324_c();
        if (Enchantment.Rarity.COMMON == r) {
            rarityFactor = 1;
        } else if (Enchantment.Rarity.UNCOMMON == r) {
            rarityFactor = 2;
        } else if (Enchantment.Rarity.RARE == r) {
            rarityFactor = 4;
        } else if (Enchantment.Rarity.VERY_RARE == r) {
            rarityFactor = 8;
        }
        return rarityFactor * lvl;
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilRepairEvent event) {
        if (TweakConfig.anvil.noRepairCost) {
            RepairCostTweak.clearRepairCost(event.getItemResult());
        }
    }

    static void clearRepairCost(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("RepairCost");
        }
    }
}

