/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randomportals.RandomPortals;
import com.therandomlabs.randomportals.api.config.FrameSizes;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.Jankson;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.api.SyntaxError;
import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.config.Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.StringUtils;

@Config(value="randomportals", path="randomportals/randomportals")
public final class RPOConfig {
    @Config.Category(value={"Options related to features that only work client-side."})
    public static final Client client = null;
    @Config.Category(value={"Options related to End portals."})
    public static final EndPortals endPortals = null;
    @Config.Category(value={"Options that don't fit into any other categories."})
    public static final Misc misc = null;
    @Config.Category(value={"Options related to Nether portals and custom portal types."})
    public static final NetherPortals netherPortals = null;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void reload() {
        FrameSizes.reload();
        try {
            PortalTypes.reload();
        }
        catch (IOException ex) {
            RandomPortals.LOGGER.error("Error while reloading Nether portal types", (Throwable)ex);
        }
    }

    public static Path getConfigPath(String name) {
        return Paths.get("config", "randomportals", name);
    }

    public static Path getConfig(String name) {
        Path path = RPOConfig.getConfigPath(name);
        Path parent = path.getParent();
        try {
            if (parent != null) {
                if (Files.isRegularFile(parent, new LinkOption[0])) {
                    Files.delete(parent);
                }
                Files.createDirectories(parent, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            RandomPortals.LOGGER.error("Failed to create parent: " + path, (Throwable)ex);
        }
        return path;
    }

    public static Path getDirectory(String name) {
        Path path = RPOConfig.getConfig(name);
        try {
            if (Files.exists(path, new LinkOption[0])) {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    Files.delete(path);
                    Files.createDirectory(path, new FileAttribute[0]);
                }
            } else {
                Files.createDirectory(path, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            RandomPortals.LOGGER.error("Failed to create directory " + path, (Throwable)ex);
        }
        return path;
    }

    public static String read(Path path) {
        try {
            return StringUtils.join(Files.readAllLines(path), (String)System.lineSeparator());
        }
        catch (IOException ex) {
            RandomPortals.LOGGER.error("Failed to read file: " + path, (Throwable)ex);
            return null;
        }
    }

    public static <T> T readJson(String jsonName, Class<T> clazz) {
        return RPOConfig.readJson(RPOConfig.getConfig(jsonName + ".json"), clazz);
    }

    public static <T> T readJson(Path path, Class<T> clazz) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        String raw = RPOConfig.read(path);
        if (raw != null) {
            try {
                Jankson jankson = Jankson.builder().build();
                raw = jankson.load(raw).toJson();
                return (T)GSON.fromJson(raw, clazz);
            }
            catch (JsonSyntaxException | SyntaxError ex) {
                RandomPortals.LOGGER.error("Failed to read JSON: " + path, ex);
            }
        }
        return null;
    }

    public static void writeJson(String jsonName, Object object) {
    }

    public static void writeJson(Path path, Object object) {
    }

    public static final class NetherPortals {
        @Config.Property(value={"Whether all entities can cause portal generation when teleported through a portal."})
        public static boolean allEntitiesCanCausePortalGeneration = RandomPatches.IS_DEOBFUSCATED;
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to enable colored portals."})
        public static boolean coloredPortals = true;
        @Config.Property(value={"Whether portals should consume dyes even if they are invalid colors (as defined by the Nether portal type)."})
        public static boolean consumeDyesEvenIfInvalidColor;
        @Config.Property(value={"Whether portals should consume dyes even if they are the same color."})
        public static boolean consumeDyesEvenIfSameColor;
        @Config.Property(value={"Whether portals should be dyeable."})
        public static boolean dyeablePortals;
        @Config.Property(value={"Whether single portal blocks can be dyed by right-clicking on them.", "This property and the above are independent of each other."})
        public static boolean dyeableSinglePortalBlocks;
        @Config.RequiresMCRestart
        @Config.Property(value={"Enables lateral Nether portals, custom portal types and a variety of Nether portal tweaks and improvements."})
        public static boolean enabled;
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to always create the \"vanilla_nether_portal\" Nether portal type when it doesn't exist."})
        public static boolean forceCreateVanillaType;
        @Config.Property(value={"Whether receiving Nether portals should be persistent.", "This makes mods like Netherless obsolete."})
        public static boolean persistentReceivingPortals;
        @Config.Property(value={"Whether portals contribute to beacon colors."})
        public static boolean portalsContributeToBeaconColors;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The radius in which a suitable location to generate a portal should be searched for upon teleportation through a portal."})
        public static int portalGenerationLocationSearchRadius;
        @Config.RangeInt(min=1)
        @Config.Property(value={"The radius in which existing portals in the destination dimension should be searched for upon teleportation through a portal."})
        public static int portalSearchRadius;
        @Config.Property(value={"Whether user placed portals inside the frame of the same type as the portal should be replaced upon activation.", "Leaving this false is recommended for building purposes, as it allows players to more easily create colored patterns in portals."})
        public static boolean replaceUserPlacedPortalsOnActivation;
        @Config.Property(value={"Whether portal ambient sounds should be server-sided instead of client-sided as in vanilla.", "This must be enabled for custom portal ambient sounds to work."})
        public static boolean serverSidedAmbientSounds;

        static {
            consumeDyesEvenIfSameColor = true;
            dyeablePortals = true;
            dyeableSinglePortalBlocks = true;
            enabled = true;
            forceCreateVanillaType = true;
            persistentReceivingPortals = true;
            portalsContributeToBeaconColors = true;
            portalGenerationLocationSearchRadius = 16;
            portalSearchRadius = 128;
            serverSidedAmbientSounds = true;
        }
    }

    public static final class Misc {
        @Config.RequiresMCRestart
        @Config.Property(value={"Whether to add an item for the End gateway."})
        public static boolean addEndGatewayItem = true;
        @Config.Property(value={"Whether to trigger advancements related to portals."})
        public static boolean advancements = true;
        @Config.RequiresWorldReload
        @Config.Property(value={"Enables the /rporeload command."})
        public static boolean rporeloadCommand = true;
    }

    public static final class EndPortals {
        @Config.RequiresMCRestart
        @Config.Property(value={"Enables vertical End portals and a variety of End portal tweaks."})
        public static boolean enabled = true;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Property(value={"The chance that a villager spawns with a vertical End portal frame on their head."})
        public static double frameHeadVillagerSpawnChance = RandomPatches.IS_DEOBFUSCATED ? 0.5 : 0.01;
        @Config.Property(value={"Whether players can right click villagers with vertical End portals to put them on their heads."})
        public static boolean rightClickVillagersToConvertToFrameHeads = true;
    }

    public static final class Client {
        @Config.Property(value={"Enables the Portals creative tab."})
        public static boolean portalsCreativeTab = true;
        @Config.RequiresMCRestart
        @Config.Property(value={"Enables the client-sided /rporeloadclient command."})
        public static boolean rporeloadclientCommand = true;
    }
}

