/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.towers;

import greymerk.roguelike.dungeon.towers.HouseTower;
import greymerk.roguelike.dungeon.towers.ITower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Random;

public enum Tower {
    ROGUE,
    ENIKO,
    ETHO,
    PYRAMID,
    JUNGLE,
    WITCH,
    HOUSE,
    BUNKER,
    RUIN,
    HOLE,
    TREE,
    BUMBO;


    public static ITower get(Tower type) {
        switch (type) {
            case ROGUE: {
                return new HouseTower();
            }
            case ENIKO: {
                return new HouseTower();
            }
            case ETHO: {
                return new HouseTower();
            }
            case PYRAMID: {
                return new HouseTower();
            }
            case JUNGLE: {
                return new HouseTower();
            }
            case WITCH: {
                return new HouseTower();
            }
            case HOUSE: {
                return new HouseTower();
            }
            case BUNKER: {
                return new HouseTower();
            }
            case RUIN: {
                return new HouseTower();
            }
            case HOLE: {
                return new HouseTower();
            }
            case TREE: {
                return new HouseTower();
            }
            case BUMBO: {
                return new HouseTower();
            }
        }
        return new HouseTower();
    }

    public static Theme getDefaultTheme(Tower type) {
        switch (type) {
            case ETHO: {
                return Theme.HOUSE;
            }
            case PYRAMID: {
                return Theme.HOUSE;
            }
            case JUNGLE: {
                return Theme.HOUSE;
            }
            case WITCH: {
                return Theme.HOUSE;
            }
            case HOUSE: {
                return Theme.HOUSE;
            }
            case BUMBO: {
                return Theme.HOUSE;
            }
        }
        return Theme.HOUSE;
    }

    public static Coord getBaseCoord(IWorldEditor editor, Coord pos) {
        Coord cursor = new Coord(pos.getX(), 128, pos.getZ());
        while (cursor.getY() > 60 && !editor.validGroundBlock(cursor)) {
            cursor.add(Cardinal.DOWN);
        }
        cursor.add(Cardinal.UP);
        int yOffset = cursor.getY() - pos.getY();
        if (yOffset < 14) {
            yOffset = 14;
        }
        return new Coord(pos.getX(), pos.getY() + yOffset, pos.getZ());
    }

    public static Tower get(String name) throws Exception {
        if (!Tower.contains(name.toUpperCase())) {
            throw new Exception("No such tower type: " + name);
        }
        return Tower.valueOf(name.toUpperCase());
    }

    public static boolean contains(String name) {
        for (Tower value : Tower.values()) {
            if (!value.toString().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Tower getRandom(Random rand) {
        return Tower.values()[rand.nextInt(Tower.values().length)];
    }
}

