/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.integration;

import com.google.common.eventbus.Subscribe;
import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.core.RPTransformer;
import com.therandomlabs.randompatches.integration.config.RPIConfig;
import com.therandomlabs.randompatches.integration.patch.BlocksItemsPatch;
import com.therandomlabs.randompatches.integration.patch.MorpheusEventHandlerPatch;
import com.therandomlabs.randompatches.integration.patch.VillagePatch;
import com.therandomlabs.randompatches.integration.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randompatches.integration.repackage.com.therandomlabs.randomlib.config.CommandConfigReload;
import com.therandomlabs.randompatches.integration.repackage.com.therandomlabs.randomlib.config.ConfigManager;
import com.therandomlabs.randompatches.util.RPUtils;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RPIntegration {
    public static final String MOD_ID = "rpintegration";
    public static final String NAME = "RandomPatches Integration";
    public static final String VERSION = "1.12.2-1.5.1.0";
    public static final String CERTIFICATE_FINGERPRINT = "20d08fb3fe9c268a63a75d337fb507464c8aaccd";
    public static final String MC_VERSION = "1.12.2";
    public static final Logger LOGGER = LogManager.getLogger((String)"rpintegration");
    public static final boolean LITELOADER_INSTALLED = RPUtils.detect((String)"com.mumfrey.liteloader.core.LiteLoader");
    public static final boolean MUON_INSTALLED = RPUtils.detect((String)"gd.izno.mc.muon.MuonPlugin");

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (RPIConfig.Client.rpireloadclient && TRLUtils.IS_CLIENT) {
            ClientCommandHandler.instance.func_71560_a((ICommand)CommandConfigReload.client("rpireloadclient", RPIConfig.class));
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        ConfigManager.registerEventHandler();
    }

    @Subscribe
    public void serverStarting(FMLServerStartingEvent event) {
        if (RPIConfig.Misc.rpireload) {
            event.registerServerCommand((ICommand)CommandConfigReload.server("rpireload", "rpireloadclient", RPIConfig.class, "RandomPatches Integration configuration reloaded!"));
        }
    }

    public static void init() {
        ConfigManager.register(RPIConfig.class);
        RPIntegration.registerPatches();
    }

    public static void containerInit() {
        if (!RPUtils.hasFingerprint(RPIntegration.class, (String)CERTIFICATE_FINGERPRINT)) {
            if (RandomPatches.IS_DEOBFUSCATED) {
                LOGGER.debug("Invalid fingerprint detected!");
            } else {
                LOGGER.error("Invalid fingerprint detected!");
            }
        }
    }

    private static void registerPatches() {
        if (RPIConfig.Client.fixLiteLoaderRegistrySubstitution && LITELOADER_INSTALLED) {
            BlocksItemsPatch patch = new BlocksItemsPatch();
            RPTransformer.register((String)"net.minecraft.init.Blocks", (Patch)patch);
            RPTransformer.register((String)"net.minecraft.init.Items", (Patch)patch);
        }
        if (RPIConfig.Misc.fixMuonCrash && MUON_INSTALLED) {
            RPTransformer.register((String)"net.minecraft.world.gen.structure.StructureVillagePieces$Village", (Patch)new VillagePatch());
        }
        if (!RPIConfig.Misc.morpheusSetSpawnMessage.isEmpty()) {
            RPTransformer.register((String)"net.quetzi.morpheus.helpers.MorpheusEventHandler", (Patch)new MorpheusEventHandlerPatch());
        }
    }
}

