/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.thetorg.blocks.TorgoSignTileEntity;
import org.thetorg.network.NetworkHandler;
import org.thetorg.network.PacketUpdateTorgoSign;

public class TorgoSignGUI
extends GuiScreen {
    private final World world;
    private final BlockPos pos;
    private TorgoSignTileEntity tileEntity;
    private GuiTextField[] textFields;
    private GuiButton saveButton;
    private GuiButton cancelButton;

    public TorgoSignGUI(World world, BlockPos pos) {
        System.out.println("TORGO: TorgoSignGUI constructor called for pos " + pos);
        this.world = world;
        this.pos = pos;
        TileEntity te = world.func_175625_s(pos);
        System.out.println("TORGO: TileEntity at pos: " + te);
        if (te instanceof TorgoSignTileEntity) {
            this.tileEntity = (TorgoSignTileEntity)te;
            System.out.println("TORGO: Found TorgoSignTileEntity");
        } else {
            System.out.println("TORGO: ERROR - TileEntity is not TorgoSignTileEntity: " + (te != null ? te.getClass() : "null"));
        }
    }

    public void func_73866_w_() {
        System.out.println("TORGO: TorgoSignGUI initGui() called");
        super.func_73866_w_();
        int centerX = this.field_146294_l / 2;
        int startY = this.field_146295_m / 2 - 50;
        this.textFields = new GuiTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.textFields[i] = new GuiTextField(i, this.field_146289_q, centerX - 75, startY + i * 25, 150, 20);
            this.textFields[i].func_146203_f(15);
            if (this.tileEntity == null) continue;
            this.textFields[i].func_146180_a(this.tileEntity.getTextLine(i));
        }
        this.textFields[0].func_146195_b(true);
        this.saveButton = new GuiButton(100, centerX - 50, startY + 110, 45, 20, "Save");
        this.cancelButton = new GuiButton(101, centerX + 5, startY + 110, 45, 20, "Cancel");
        this.field_146292_n.add(this.saveButton);
        this.field_146292_n.add(this.cancelButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int centerX = this.field_146294_l / 2;
        int startY = this.field_146295_m / 2 - 70;
        this.func_73732_a(this.field_146289_q, "Edit Torgo Sign", centerX, startY, 0xFFFFFF);
        for (int i = 0; i < 4; ++i) {
            this.func_73731_b(this.field_146289_q, "Line " + (i + 1) + ":", centerX - 75, startY + 25 + i * 25, 0xFFFFFF);
            this.textFields[i].func_146194_f();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean handled = false;
        for (GuiTextField field : this.textFields) {
            if (!field.func_146201_a(typedChar, keyCode)) continue;
            handled = true;
            break;
        }
        if (keyCode == 15) {
            int currentFocused = -1;
            for (int i = 0; i < this.textFields.length; ++i) {
                if (!this.textFields[i].func_146206_l()) continue;
                currentFocused = i;
                this.textFields[i].func_146195_b(false);
                break;
            }
            int nextFocused = (currentFocused + 1) % this.textFields.length;
            this.textFields[nextFocused].func_146195_b(true);
            handled = true;
        }
        if (!handled) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiTextField field : this.textFields) {
            field.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 100) {
            this.saveAndClose();
        } else if (button.field_146127_k == 101) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    private void saveAndClose() {
        if (this.tileEntity != null) {
            String[] lines = new String[4];
            for (int i = 0; i < 4; ++i) {
                lines[i] = this.textFields[i].func_146179_b();
            }
            this.tileEntity.setTextLines(lines);
            if (NetworkHandler.INSTANCE != null) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketUpdateTorgoSign(this.pos, lines));
            } else {
                System.out.println("TORGO: NetworkHandler not ready, cannot send packet");
            }
        }
        this.field_146297_k.func_147108_a(null);
    }

    public boolean func_73868_f() {
        return false;
    }
}

