/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.torgy.torgo.Torgo;

public class LongsnapUpdater {
    private static final String LONGSNAP_URL = "https://minecraft.thetorg.org/minecraft/longsnap.jar";
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final int READ_TIMEOUT_MS = 60000;
    private static final String FILENAME = "longsnap.jar";

    public static void updateLongsnap() {
        try {
            File destinationFile;
            URL longsnapURL = new URL(LONGSNAP_URL);
            String fullPath = Torgo.class.getResource("Torgo.class").toString();
            String jarPath = fullPath.split("!")[0].replace("jar:", "");
            File jarFile = new File(new URI(jarPath));
            File torgoModPath = jarFile.getParentFile();
            File modPathParent = torgoModPath.getParentFile();
            File skipUpdate = new File(modPathParent, "skipupdate");
            if (skipUpdate.exists()) {
                return;
            }
            File serverPropertiesFile = new File(modPathParent, "server.properties");
            if (!serverPropertiesFile.exists()) {
                destinationFile = new File(modPathParent.getParentFile(), "libraries/longsnap.jar");
                LongsnapUpdater.downloadFile(longsnapURL, destinationFile);
                LongsnapUpdater.killPrism();
                LongsnapUpdater.updateInstanceCfg(new File(modPathParent.getParentFile(), "instance.cfg").toString());
            }
            destinationFile = new File(modPathParent, FILENAME);
            LongsnapUpdater.downloadFile(longsnapURL, destinationFile);
        }
        catch (Exception e) {
            System.err.println("Failed to update Longsnap");
            e.printStackTrace();
        }
    }

    public static void updateInstanceCfg(String filePath) {
        Throwable throwable;
        File cfgFile = new File(filePath);
        StringBuilder newContent = new StringBuilder();
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(cfgFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("OverrideCommands=")) {
                        line = "OverrideCommands=true";
                    }
                    if (line.startsWith("PreLaunchCommand=")) {
                        line = "PreLaunchCommand=\\\"$INST_JAVA\\\"  -jar \\\"$INST_MC_DIR\\\"/longsnap.jar";
                    }
                    newContent.append(line).append(System.lineSeparator());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            throwable = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(cfgFile));){
                writer.write(newContent.toString());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void killPrism() {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            String command = "";
            System.out.println("TORGO Detected OS: " + osName);
            if (osName.contains("win")) {
                System.out.println("TORGO Executing Windows kill command.");
                command = "taskkill /F /IM prismlauncher.exe";
            } else if (osName.contains("mac")) {
                System.out.println("TORGO Executing Mac kill command.");
                command = "kill $(ps -ef |grep prismlaunche[r]|grep -v java|awk '{print $2}')";
            } else {
                System.out.println("TORGO Executing generic UNIX kill command.");
                command = "kill $(ps -ef |grep prismlaunche[r]|grep -v java|awk '{print $2}')";
            }
            LongsnapUpdater.runShellCommand(command, osName);
        }
        catch (Exception e) {
            System.out.println("TORGO Exception occurred while trying to kill Prism.");
            e.printStackTrace();
        }
    }

    public static void runShellCommand(String command, String osName) {
        try {
            String s;
            String[] cmd;
            System.out.println("TORGO: " + osName);
            if (osName.contains("win")) {
                cmd = new String[]{"cmd.exe", "/c", command};
                System.out.println("TORGO1: " + cmd);
            } else {
                cmd = new String[]{"/bin/sh", "-c", command};
                System.out.println("TORGO2: " + cmd);
            }
            System.out.println("TORGO: " + cmd + " " + osName);
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            System.out.println("TORGO0: " + command);
            while ((s = stdInput.readLine()) != null) {
                System.out.println("TORGO1: " + s);
            }
            while ((s = stdError.readLine()) != null) {
                System.out.println("TORGO2: " + s);
            }
            int exitCode = process.waitFor();
            System.out.println("TORGO3 Exit code: " + exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void downloadFile(URL url, File destination) throws Exception {
        System.out.println("Downloading file FROM: " + url + " TO: " + destination);
        destination.getParentFile().mkdirs();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(60000);
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(destination);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
    }
}

