/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo.events;

import at.feldim2425.moreoverlays.chunkbounds.ChunkBoundsHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.tileentity.TileEntityGrave;
import org.torgy.torgo.network.Slack;
import org.torgy.torgo.utils.AdvancementWorldData;
import twilightforest.block.TFBlocks;

public class PlayerTickEvents {
    public ArrayList<ItemStack> chunkBoundryTriggerItems = new ArrayList();
    public boolean inited = false;
    private static final Map<Integer, String> myMap = new HashMap<Integer, String>();
    public static float FAST_SPEED;
    public static float FASTER_SPEED;
    public static float FASTEST_SPEED;

    public void populateChunkBoundryTriggerItems(String resourceLocation) {
        this.chunkBoundryTriggerItems.add(new ItemStack((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(resourceLocation))));
    }

    public void populateChunkBoundryTriggerItems(String resourceLocation, int meta) {
        this.chunkBoundryTriggerItems.add(new ItemStack((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(resourceLocation)), 1, meta));
    }

    @SubscribeEvent
    public void playerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent e) {
        Slack.sendSlackMessage(e.player.func_70005_c_() + " logged out");
    }

    @SubscribeEvent
    public void playerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent e) {
        Slack.sendSlackMessage(e.player.func_70005_c_() + " logged in");
    }

    @SubscribeEvent
    public void onDimChange(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        int dimension = event.getDimension();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entity;
            String advancementResource = myMap.get(dimension);
            if (advancementResource != null) {
                Advancement adv = entityPlayerMP.func_71121_q().func_191952_z().func_192778_a(new ResourceLocation(advancementResource));
                if (adv == null || !entityPlayerMP.func_192039_O().func_192747_a(adv).func_192105_a()) {
                    entityPlayerMP.func_145747_a(new TextComponentString("You have not completed the necessary requirements to teleport to this dimension").func_150255_a(new Style().func_150227_a(Boolean.valueOf(true))));
                    event.setCanceled(true);
                }
            } else {
                System.out.println("TORGO: No mapping found for dimension: " + dimension);
            }
        } else if (entity instanceof EntityLivingBase) {
            System.out.println("TORGO entity: " + entity.func_70005_c_() + " is not authorized to transport to: " + dimension);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerAdvancement(AdvancementEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        String playerUUID = player.func_110124_au().toString();
        ResourceLocation resourceLocation = event.getAdvancement().func_192067_g();
        Advancement advancement = event.getAdvancement();
        boolean isComplete = player.func_192039_O().func_192747_a(advancement).func_192105_a();
        if (isComplete) {
            AdvancementWorldData.update(playerUUID + resourceLocation.toString());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void rightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockAnvil blockAnvil;
        int meta;
        BlockPos targetPos;
        ItemStack heldItemStack;
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        if (event.getWorld().func_175625_s(event.getPos()) != null && event.getWorld().func_175625_s(event.getPos()) instanceof TileEntityGrave) {
            TileEntityGrave grave = (TileEntityGrave)event.getWorld().func_175625_s(event.getPos());
            if (player instanceof EntityPlayerMP) {
                if (grave.getUsername().matches(player.func_70005_c_())) {
                    event.getWorld().func_175655_b(event.getPos(), true);
                } else {
                    TextComponentString textString = new TextComponentString("This grave belongs to: " + grave.getUsername() + ". You can not destroy this grave.");
                    player.func_145747_a((ITextComponent)textString);
                }
            }
        }
        if ((heldItemStack = player.func_184586_b(event.getHand())).func_190926_b()) {
            return;
        }
        Item heldItem = heldItemStack.func_77973_b();
        if (heldItem != Item.func_150898_a((Block)Blocks.field_150339_S)) {
            return;
        }
        World world = event.getWorld();
        IBlockState targetBlockState = world.func_180495_p(targetPos = event.getPos());
        if (targetBlockState.func_177230_c() == Blocks.field_150467_bQ && (meta = (blockAnvil = (BlockAnvil)targetBlockState.func_177230_c()).func_176201_c(targetBlockState)) > 0) {
            IBlockState newBlockState = targetBlockState.func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(0));
            world.func_175656_a(targetPos, newBlockState);
            if (!player.field_71075_bZ.field_75098_d) {
                heldItemStack.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClimbFastLadder(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            World world = player.func_130014_f_();
            int x = (int)Math.floor(player.field_70165_t);
            int y = (int)Math.floor(player.field_70163_u);
            int z = (int)Math.floor(player.field_70161_v);
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = world.func_180495_p(pos);
            if (player.func_70617_f_()) {
                double playerMotion = player.field_70181_x;
                if (state.func_177230_c() == TFBlocks.iron_ladder) {
                    this.moveOnLadder(player, FAST_SPEED);
                    player.field_70181_x = playerMotion;
                }
            }
        }
    }

    public void moveOnLadder(EntityPlayer player, float speed) {
        float motion = 0.15f;
        player.field_70159_w = MathHelper.func_151237_a((double)player.field_70159_w, (double)(-motion), (double)motion);
        player.field_70179_y = MathHelper.func_151237_a((double)player.field_70179_y, (double)(-motion), (double)motion);
        player.field_70143_R = 0.0f;
        if (player.field_70181_x < -((double)motion)) {
            player.field_70181_x = -((double)motion);
        } else if (player.field_70181_x > 0.0) {
            player.field_70181_x = speed;
        }
        boolean flag = player.func_70093_af();
        if (flag && player.field_70181_x < 0.0) {
            player.field_70181_x = 0.0;
        }
        player.func_70091_d(MoverType.PLAYER, player.field_70159_w, player.field_70181_x, player.field_70179_y);
    }

    @SubscribeEvent
    public void foo(ServerChatEvent e) {
        Slack.sendSlackMessage(e.getUsername() + ": " + e.getMessage());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(receiveCanceled=true)
    public void playerTickEvent(TickEvent.PlayerTickEvent e) {
        if (!this.inited) {
            this.inited = true;
            this.populateChunkBoundryTriggerItems("extrautils2:quarry");
            this.populateChunkBoundryTriggerItems("extrautils2:quarryproxy");
            this.populateChunkBoundryTriggerItems("mekanismgenerators:reactor");
            this.populateChunkBoundryTriggerItems("mekanismgenerators:reactorglass");
            this.populateChunkBoundryTriggerItems("mekanismgenerators:reactor", 2);
            this.populateChunkBoundryTriggerItems("mekanismgenerators:reactor", 1);
            this.populateChunkBoundryTriggerItems("mekanism:basicblock2");
            this.populateChunkBoundryTriggerItems("mekanism:basicblock", 15);
            this.populateChunkBoundryTriggerItems("mekanism:basicblock", 14);
            this.populateChunkBoundryTriggerItems("simplequarry:fuel_quarry");
            this.populateChunkBoundryTriggerItems("chickenchunks:chunk_loader");
            this.populateChunkBoundryTriggerItems("chickenchunks:chunk_loader", 1);
            this.populateChunkBoundryTriggerItems("rftools:storage_scanner");
        }
        for (int i = 0; i < this.chunkBoundryTriggerItems.size(); ++i) {
            try {
                if (!Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77969_a(this.chunkBoundryTriggerItems.get(i))) continue;
                ChunkBoundsHandler.setMode((int)2);
                return;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        ChunkBoundsHandler.setMode((int)0);
    }

    static {
        myMap.put(90, "triumph:10_overworld/trophy");
        myMap.put(111, "triumph:10_overworld/trophy");
        myMap.put(7, "triumph:30_mining/trophy");
        myMap.put(8, "triumph:40_twilight/trophy");
        myMap.put(-1, "triumph:50_hunting/trophy");
        myMap.put(1, "triumph:60_nether/trophy");
        myMap.put(-28, "triumph:70_end/trophy");
        myMap.put(-29, "triumph:80_moon/trophy");
        myMap.put(-31, "triumph:90_mars/trophy");
        FAST_SPEED = 0.206f;
        FASTER_SPEED = 0.1476f;
        FASTEST_SPEED = 0.206f;
    }
}

