/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.advancements.display.ExtendedDisplayInfo;
import com.bloodnbonesgaming.triumph.advancements.display.HiddenAlways;
import com.bloodnbonesgaming.triumph.advancements.display.HiddenIf;
import com.bloodnbonesgaming.triumph.advancements.display.HiddenUnless;
import com.bloodnbonesgaming.triumph.advancements.display.VisibilityOption;
import com.bloodnbonesgaming.triumph.advancements.display.VisibleAlways;
import com.bloodnbonesgaming.triumph.advancements.display.VisibleIf;
import com.bloodnbonesgaming.triumph.advancements.display.VisibleUnless;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;

public class AdvancementDisplayData {
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).create();
    private ItemBlockData icon;
    private String title;
    private String description;
    private boolean translateDescription = false;
    private FrameType frameType;
    private ResourceLocation background;
    private boolean showToast = true;
    private boolean announceToChat = true;
    private boolean hidden = false;
    private int uncompletedIconColor = -1;
    private int completedIconColor = -1;
    private int uncompletedTitleColor = -1;
    private int completedTitleColor = -1;
    private Integer posX = null;
    private Integer posY = null;
    private Boolean drawDirectLines = null;
    private int uncompletedLineColor = -1;
    private int completedLineColor = -1;
    private Boolean hideLines = null;
    private final List<ResourceLocation> extraConnections = new ArrayList<ResourceLocation>();
    private final List<VisibilityOption> visibilityOptions = new ArrayList<VisibilityOption>();

    public void setUncompletedIconColor(int color) {
        this.uncompletedIconColor = color;
    }

    public void setUncompletedIconColor(String hex) {
        try {
            int color;
            this.uncompletedIconColor = color = Integer.parseUnsignedInt(hex, 16);
        }
        catch (Exception e) {
            Triumph.instance.getLog().error((Object)(hex + " cannot be converted to a color!"));
        }
    }

    public void setUncompletedIconColor(int red, int green, int blue) {
        this.uncompletedIconColor = new Color(red, blue, green).getRGB();
    }

    public void setCompletedIconColor(int color) {
        this.completedIconColor = color;
    }

    public void setCompletedIconColor(String hex) {
        try {
            int color;
            this.completedIconColor = color = Integer.parseUnsignedInt(hex, 16);
        }
        catch (Exception e) {
            Triumph.instance.getLog().error((Object)(hex + " cannot be converted to a color!"));
        }
    }

    public void setCompletedIconColor(int red, int green, int blue) {
        this.completedIconColor = new Color(red, green, blue).getRGB();
    }

    public void setUncompletedTitleColor(int color) {
        this.uncompletedTitleColor = color;
    }

    public void setUncompletedTitleColor(String hex) {
        try {
            int color;
            this.uncompletedTitleColor = color = Integer.parseUnsignedInt(hex, 16);
        }
        catch (Exception e) {
            Triumph.instance.getLog().error((Object)(hex + " cannot be converted to a color!"));
        }
    }

    public void setUncompletedTitleColor(int red, int green, int blue) {
        this.uncompletedTitleColor = new Color(red, green, blue).getRGB();
    }

    public void setCompletedTitleColor(int color) {
        this.completedTitleColor = color;
    }

    public void setCompletedTitleColor(String hex) {
        try {
            int color;
            this.completedTitleColor = color = Integer.parseUnsignedInt(hex, 16);
        }
        catch (Exception e) {
            Triumph.instance.getLog().error((Object)(hex + " cannot be converted to a color!"));
        }
    }

    public void setCompletedTitleColor(int red, int green, int blue) {
        this.completedTitleColor = new Color(red, green, blue).getRGB();
    }

    public void drawDirectLines(boolean bool) {
        this.drawDirectLines = bool;
    }

    public void hideLines() {
        this.hideLines = true;
    }

    public void setUncompletedLineColor(int color) {
        this.uncompletedLineColor = color;
    }

    public void setCompletedLineColor(int color) {
        this.completedLineColor = color;
    }

    public void setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.translateDescription = false;
        this.description = description;
    }

    public void setTranslatedTitle(String title) {
        this.title = "{\"translate\":\"" + title + "\"}";
    }

    public void setTranslatedDescription(String description) {
        this.translateDescription = true;
        this.description = description;
    }

    public ItemBlockData getIcon() {
        if (this.icon == null) {
            this.icon = new ItemBlockData();
        }
        return this.icon;
    }

    public void setIcon(ItemBlockData data) {
        this.icon = data;
    }

    public void setIcon(String itemName) {
        this.setIcon(itemName, 0);
    }

    public void setIcon(String itemName, int meta) {
        this.getIcon().setLocation(itemName);
        this.getIcon().setMeta(new MinMaxBounds(Float.valueOf(meta), Float.valueOf(meta)));
    }

    public void setIcon(String itemName, int meta, String nbt) throws NBTException {
        this.getIcon().setLocation(itemName);
        this.getIcon().setMeta(new MinMaxBounds(Float.valueOf(meta), Float.valueOf(meta)));
        this.getIcon().setNBT(nbt);
    }

    public void setFrameType(String frameType) {
        FrameType frame = FrameType.valueOf((String)frameType.toUpperCase());
        if (frame != null) {
            this.frameType = frame;
        }
    }

    public void setBackground(String location) {
        this.background = new ResourceLocation(location);
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setShowToast(boolean showToast) {
        this.showToast = showToast;
    }

    public void setAnnounceToChat(boolean announceToChat) {
        this.announceToChat = announceToChat;
    }

    public void addExtraConnection(ResourceLocation connection) {
        this.extraConnections.add(connection);
    }

    public void alwaysVisible() {
        this.visibilityOptions.add(new VisibleAlways());
    }

    public void alwaysHidden() {
        this.visibilityOptions.add(new HiddenAlways());
    }

    public void visibleIf(String string) {
        this.visibilityOptions.add(new VisibleIf(string));
    }

    public void hiddenIf(String string) {
        this.visibilityOptions.add(new HiddenIf(string));
    }

    public void visibleUnless(String string) {
        this.visibilityOptions.add(new VisibleUnless(string));
    }

    public void hiddenUnless(String string) {
        this.visibilityOptions.add(new HiddenUnless(string));
    }

    public void addVisibilityOption(VisibilityOption option) {
        this.visibilityOptions.add(option);
    }

    public List<ResourceLocation> getExtraConnections() {
        return this.extraConnections;
    }

    public ITextComponent buildDescription() {
        if (this.description != null) {
            if (this.translateDescription) {
                return new TextComponentTranslation(this.description, new Object[0]);
            }
            JsonParser parser = new JsonParser();
            JsonObject jsonObj = this.description.startsWith("{") && this.description.endsWith("}") ? (JsonObject)parser.parse("{\"Description\":" + this.description + "}") : (JsonObject)parser.parse("{\"Description\":\"" + this.description + "\"}");
            return (ITextComponent)GSON.fromJson(jsonObj.get("Description"), ITextComponent.class);
        }
        return null;
    }

    public ITextComponent buildTitle() {
        if (this.title != null) {
            JsonParser parser = new JsonParser();
            JsonObject jsonObj = this.title.startsWith("{") && this.title.endsWith("}") ? (JsonObject)parser.parse("{\"Title\":" + this.title + "}") : (JsonObject)parser.parse("{\"Title\":\"" + this.title + "\"}");
            return (ITextComponent)GSON.fromJson(jsonObj.get("Title"), ITextComponent.class);
        }
        return null;
    }

    public DisplayInfo buildDisplayInfo(ResourceLocation advancementName) throws Exception {
        ITextComponent description;
        ITextComponent title;
        ItemStack icon;
        if (this.icon != null && (icon = this.icon.buildItemStack()) != null && (title = this.buildTitle()) != null && (description = this.buildDescription()) != null) {
            FrameType frameType = this.frameType != null ? this.frameType : FrameType.TASK;
            ExtendedDisplayInfo info = new ExtendedDisplayInfo(advancementName, icon, title, description, this.background, frameType, this.showToast, this.announceToChat, this.hidden, this.uncompletedIconColor, this.completedIconColor, this.uncompletedTitleColor, this.completedTitleColor, this.posX, this.posY, this.drawDirectLines, this.uncompletedLineColor, this.completedLineColor, this.hideLines, this.extraConnections, this.visibilityOptions);
            return info;
        }
        return null;
    }
}

