/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashMap;
import java.util.List;
import net.darkhax.wawla.config.Configurable;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.darkhax.wawla.plugins.ProviderType;
import net.darkhax.wawla.plugins.WawlaFeature;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import twilightforest.entity.passive.EntityTFQuestRam;

@WawlaFeature(description="Shows information about breedable animals", name="animals", type=ProviderType.ENTITY)
public class PluginAnimal
extends InfoProvider {
    @Configurable(category="animals", description="Should the breedting timer be shown?")
    public static boolean showBreedingCooldown = true;
    @Configurable(category="animals", description="Should the growing timer be shown?")
    public static boolean showGrowingCooldown = true;
    @Configurable(category="animals", description="Should the correct breeding item reflect in the hud?")
    public static boolean showBreedingItem = true;
    private HashMap<Integer, String> colors = new HashMap();
    private boolean init = false;

    @Override
    public void addEntityInfo(List<String> info, InfoAccess data) {
        if (!this.init) {
            this.colors.put(0, "White");
            this.colors.put(1, "Orange");
            this.colors.put(2, "Magenta");
            this.colors.put(3, "Light Blue");
            this.colors.put(4, "Yellow");
            this.colors.put(5, "Green");
            this.colors.put(6, "Pink");
            this.colors.put(7, "Gray");
            this.colors.put(8, "Light Gray");
            this.colors.put(9, "Cyan");
            this.colors.put(10, "Purple");
            this.colors.put(11, "Blue");
            this.colors.put(12, "Brown");
            this.colors.put(13, "Green");
            this.colors.put(14, "Red");
            this.colors.put(15, "Black");
            this.init = true;
        }
        if (data.entity instanceof EntityAnimal) {
            int age;
            EntityAnimal entity = (EntityAnimal)data.entity;
            if (data.entity instanceof EntityTFQuestRam) {
                EntityTFQuestRam entityTFQuestRam = (EntityTFQuestRam)data.entity;
                String missing = "";
                for (int i = 0; i < EnumDyeColor.values().length; ++i) {
                    if (entityTFQuestRam.isColorPresent(EnumDyeColor.func_176764_b((int)i))) continue;
                    missing = missing + " " + this.colors.get(i);
                }
                if (!missing.isEmpty()) {
                    info.add("Wool Colors Missing:" + missing);
                }
            }
            if ((age = data.tag.func_74762_e("AnimalGrowingAge")) != 0) {
                if (showBreedingCooldown && age < 0) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.growingage", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)Math.abs(age)));
                }
                if (showGrowingCooldown && age > 0) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.breedingtime", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)age));
                }
            }
            if (showBreedingItem && data.player.func_184614_ca() != null && entity.func_70877_b(data.player.func_184614_ca())) {
                info.add(ChatFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.wawla.generic.breedingitem", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void writeEntityNBT(World world, Entity entity, NBTTagCompound tag) {
        if (entity instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)entity;
            if (showBreedingCooldown || showGrowingCooldown) {
                tag.func_74768_a("AnimalGrowingAge", animal.func_70874_b());
            }
        }
    }

    @Override
    public boolean requireEntitySync(World world, Entity entity) {
        return entity instanceof EntityAnimal;
    }
}

