/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.config.ModConfiguration;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.structures.config.ModerateHouseConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructureModerateHouse;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiModerateHouse
extends GuiStructure {
    protected ModerateHouseConfiguration configuration;
    protected GuiButtonExt btnHouseStyle;
    protected GuiCheckBox btnAddChest;
    protected GuiCheckBox btnAddChestContents;
    protected GuiCheckBox btnAddMineShaft;
    protected GuiButtonExt btnBedColor;
    protected boolean allowItemsInChestAndFurnace = true;
    protected ModConfiguration serverConfiguration;

    public GuiModerateHouse() {
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.ModerateHouse;
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 215;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Moderate Houses", ModerateHouseConfiguration.class);
        this.configuration.pos = this.pos;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnHouseStyle = this.createAndAddButton(4, grayBoxX + 8, grayBoxY + 25, 90, 20, this.configuration.houseStyle.getDisplayName(), false);
        this.btnBedColor = this.createAndAddDyeButton(5, grayBoxX + 8, grayBoxY + 60, 90, 20, this.configuration.bedColor);
        this.btnAddChest = this.createAndAddCheckBox(6, grayBoxX + 8, grayBoxY + 120, "prefab.gui.starter.addchest", this.configuration.addChests);
        this.btnAddMineShaft = this.createAndAddCheckBox(8, grayBoxX + 8, grayBoxY + 137, "prefab.gui.starter.buildmineshaft", this.configuration.addChestContents);
        this.btnAddChestContents = this.createAndAddCheckBox(7, grayBoxX + 8, grayBoxY + 154, "prefab.gui.starter.addchestcontents", this.configuration.addMineshaft);
        this.btnVisualize = this.createAndAddCustomButton(3, grayBoxX + 24, grayBoxY + 177, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 310, grayBoxY + 177, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(2, grayBoxX + 154, grayBoxY + 177, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 136;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.func_146276_q_();
        this.drawControlLeftPanel(x + 2, y + 10, 135, 190);
        this.drawControlRightPanel(imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindTexture(this.configuration.houseStyle.getHousePicture());
        Gui.func_152125_a((int)imageLocation, (int)(y + 15), (float)0.0f, (float)0.0f, (int)this.shownImageWidth, (int)this.shownImageHeight, (int)this.shownImageWidth, (int)this.shownImageHeight, (float)this.shownImageWidth, (float)this.shownImageHeight);
        this.btnAddChest.field_146125_m = this.serverConfiguration.addChests;
        this.btnAddChestContents.field_146125_m = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
        this.btnAddMineShaft.field_146125_m = this.serverConfiguration.addMineshaft;
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(GuiLangKeys.translateString("prefab.gui.starter.style.label"), x + 8, y + 15, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 8, y + 50, this.textColor);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.configuration.addChests = this.btnAddChest.field_146125_m && this.btnAddChest.isChecked();
        this.configuration.addChestContents = this.allowItemsInChestAndFurnace && this.btnAddChestContents.field_146125_m && this.btnAddChestContents.isChecked();
        this.configuration.addMineshaft = this.btnAddMineShaft.field_146125_m && this.btnAddMineShaft.isChecked();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.configuration.houseStyle.getValue() + 1;
            this.configuration.houseStyle = ModerateHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.field_146126_j = this.configuration.houseStyle.getDisplayName();
        } else if (button == this.btnVisualize) {
            StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.configuration.houseStyle.getStructureLocation(), StructureModerateHouse.class);
            this.performPreview(structure, this.configuration);
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = EnumDyeColor.func_176764_b((int)(this.configuration.bedColor.func_176765_a() + 1));
            GuiUtils.setButtonText((GuiButton)this.btnBedColor, GuiLangKeys.translateDye(this.configuration.bedColor));
        }
    }
}

