/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.messages;

import com.wuest.prefab.proxy.messages.TagMessage;
import com.wuest.prefab.structures.config.BasicStructureConfiguration;
import com.wuest.prefab.structures.config.BulldozerConfiguration;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.config.ModerateHouseConfiguration;
import com.wuest.prefab.structures.config.ModularHouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.StructurePartConfiguration;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class StructureTagMessage
extends TagMessage {
    protected EnumStructureConfiguration structureConfig;

    public StructureTagMessage() {
    }

    public StructureTagMessage(NBTTagCompound tagMessage, EnumStructureConfiguration structureConfig) {
        super(tagMessage);
        this.structureConfig = structureConfig;
    }

    public EnumStructureConfiguration getStructureConfig() {
        return this.structureConfig;
    }

    public void setStructureConfig(EnumStructureConfiguration value) {
        this.structureConfig = value;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.structureConfig = EnumStructureConfiguration.getFromIdentifier(tag.func_74762_e("config"));
        this.tagMessage = tag.func_74775_l("dataTag");
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("config", this.structureConfig.identifier);
        tag.func_74782_a("dataTag", (NBTBase)this.tagMessage);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static enum EnumStructureConfiguration {
        Basic(0, new BasicStructureConfiguration()),
        ModularHouse(1, new ModularHouseConfiguration()),
        StartHouse(2, new HouseConfiguration()),
        ModerateHouse(3, new ModerateHouseConfiguration()),
        Bulldozer(4, new BulldozerConfiguration()),
        InstantBridge(5, new InstantBridgeConfiguration()),
        Parts(6, new StructurePartConfiguration());

        public int identifier;
        public StructureConfiguration structureConfig;

        private <T extends StructureConfiguration> EnumStructureConfiguration(int identifier, T structureConfig) {
            this.identifier = identifier;
            this.structureConfig = structureConfig;
        }

        public static EnumStructureConfiguration getFromIdentifier(int identifier) {
            for (EnumStructureConfiguration config : EnumStructureConfiguration.values()) {
                if (config.identifier != identifier) continue;
                return config;
            }
            return Basic;
        }

        public static EnumStructureConfiguration getByConfigurationInstance(StructureConfiguration structureConfig) {
            for (EnumStructureConfiguration configuration : EnumStructureConfiguration.values()) {
                if (!configuration.structureConfig.getClass().equals(structureConfig.getClass())) continue;
                return configuration;
            }
            return null;
        }
    }
}

